#include <bits/stdc++.h>
using namespace std;

struct Event {
    long double ang;
    int id;
    int type; // +1 add, -1 remove
};

static inline long double normAng(long double a) {
    const long double TWO_PI = 2.0L * acosl(-1.0L);
    while (a < 0) a += TWO_PI;
    while (a >= TWO_PI) a -= TWO_PI;
    return a;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> x(n+1), y(n+1);

    vector<Event> ev;
    ev.reserve(2LL * n);

    // start u at angle 0 => u = (1,0)
    long long Sx = 0, Sy = 0;
    vector<char> in(n+1, 0);

    const long double PI = acosl(-1.0L);

    for (int i = 1; i <= n; i++) {
        cin >> x[i] >> y[i];
        if (x[i] == 0 && y[i] == 0) continue;

        // initial membership at theta = 0: u·v = x
        if (x[i] > 0) {
            in[i] = 1;
            Sx += x[i];
            Sy += y[i];
        }

        long double phi = atan2l((long double)y[i], (long double)x[i]);

        // u·v > 0 when theta in (phi-PI/2, phi+PI/2)
        // so: entering interval at phi-PI/2 (ADD), leaving at phi+PI/2 (REMOVE)
        long double a_add = normAng(phi - PI/2);
        long double a_rem = normAng(phi + PI/2);

        ev.push_back({a_add, i, +1});
        ev.push_back({a_rem, i, -1});
    }

    sort(ev.begin(), ev.end(), [](const Event& A, const Event& B){
        if (A.ang != B.ang) return A.ang < B.ang;
        return A.type > B.type; // add before remove at same angle (doesn't really matter with epsilon)
    });

    auto eval = [&](long double theta, long long cx, long long cy) -> long double {
        long double ux = cosl(theta), uy = sinl(theta);
        return ux * (long double)cx + uy * (long double)cy; // u·S
    };

    long double bestVal = -1;
    long double bestTheta = 0;

    long double prev = 0;

    int m = (int)ev.size();
    int idx = 0;

    auto consider_interval = [&](long double L, long double R, long long cx, long long cy) {
        // On (L,R) membership is constant, S is fixed.
        if (cx == 0 && cy == 0) return;

        long double dir = atan2l((long double)cy, (long double)cx);
        dir = normAng(dir);

        // since sweep is within [0,2pi), intervals do not wrap inside loop
        // check if dir in (L,R)
        if (L < dir && dir < R) {
            long double val = hypotl((long double)cx, (long double)cy); // max possible u·S
            if (val > bestVal) { bestVal = val; bestTheta = dir; }
        } else {
            // best at the nearer endpoint (or just check both)
            long double v1 = eval(L, cx, cy);
            long double v2 = eval(R, cx, cy);
            if (v1 > bestVal) { bestVal = v1; bestTheta = L; }
            if (v2 > bestVal) { bestVal = v2; bestTheta = R; }
        }
    };

    // sweep through events
    while (idx < m) {
        long double cur = ev[idx].ang;

        // interval (prev, cur)
        if (cur > prev + 1e-18L) {
            consider_interval(prev, cur, Sx, Sy);
        }

        // process all events at angle cur
        while (idx < m && fabsl(ev[idx].ang - cur) <= 1e-18L) {
            int id = ev[idx].id;
            int type = ev[idx].type;

            // membership changes when crossing this angle in increasing theta:
            // ADD means it becomes positive after crossing, REMOVE means becomes non-positive after crossing.
            if (type == +1) {
                if (!in[id]) { in[id] = 1; Sx += x[id]; Sy += y[id]; }
            } else {
                if (in[id]) { in[id] = 0; Sx -= x[id]; Sy -= y[id]; }
            }
            idx++;
        }

        prev = cur;
    }

    // last interval (prev, 2pi)
    const long double TWO_PI = 2.0L * PI;
    if (TWO_PI > prev + 1e-18L) {
        consider_interval(prev, TWO_PI, Sx, Sy);
    }

    // build answer using bestTheta (strictly positive projection)
    long double ux = cosl(bestTheta), uy = sinl(bestTheta);
    const long double EPS = 1e-12L;

    vector<int> ans;
    ans.reserve(n);
    for (int i = 1; i <= n; i++) {
        if (x[i] == 0 && y[i] == 0) continue;
        long double dot = ux * (long double)x[i] + uy * (long double)y[i];
        if (dot > EPS) ans.push_back(i);
    }

    cout << ans.size() << "\n";
    for (int i = 0; i < (int)ans.size(); i++) {
        if (i) cout << " ";
        cout << ans[i];
    }
    cout << "\n";
    return 0;
}